/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/    

#ifndef __SDMMC_TEST__
#define __SDMMC_TEST__

#define SECTOR_SIZE		(512)
#define CLK_INITSEQ    	(0)
#define CLK_400KHZ     	(1)
#define CLK_12MHZ      	(2)
#define CLK_24MHZ		(3)
#define CLK_48MHZ		(4)
#define SDMMC_REF_CLK	(192)
#define FAILURE			FAILED

/* Responses */
#define RSP_TYPE_NONE	(0 << 16) 
#define RSP_TYPE_R1		(2 << 16  | 1 << 19 | 1 << 20)
#define RSP_TYPE_R1B	(3 << 16  | 1 << 19 | 1 << 20)
#define RSP_TYPE_R2		(1 << 16  | 1 << 19)
#define RSP_TYPE_R3		(2 << 16)
#define RSP_TYPE_R4		(2 << 16)
#define RSP_TYPE_R5		(2 << 16  | 1 << 19 | 1 << 20)
#define RSP_TYPE_R6		(2 << 16  | 1 << 19 | 1 << 20)	
#define RSP_TYPE_R7		(2 << 16  | 1 << 19 | 1 << 20)

/* All supported commands */
#define SDMMC_CMD0		(0 << 24  | RSP_TYPE_NONE |  0 << 4)
#define SDMMC_CMD1		(1 << 24  | RSP_TYPE_R3   |  1 << 4)
#define SDMMC_CMD2		(2 << 24  | RSP_TYPE_R2   |  1 << 4)
#define SDMMC_CMD3		(3 << 24  | RSP_TYPE_R1   |  1 << 4)
#define MMC_CMD3		(3 << 24  | RSP_TYPE_R6   |  1 << 4) 
#define SDMMC_CMD4		(4 << 24  | RSP_TYPE_NONE |  1 << 4)
#define SDMMC_CMD5		(5 << 24  | RSP_TYPE_R4   |  1 << 4)
#define SDMMC_CMD6		(6 << 24  | RSP_TYPE_R1B  |  1 << 4)
#define SDMMC_CMD7		(7 << 24  | RSP_TYPE_R1B  |  1 << 4)
#define SDMMC_CMD8		(8 << 24  | RSP_TYPE_R1   |  1 << 21  | 0 << 4)
#define SDMMC_SDCMD8	(8 << 24  | RSP_TYPE_R7   |  1 << 4)
#define SDMMC_CMD9		(9 << 24  | RSP_TYPE_R2   |  1 << 4)
#define SDMMC_CMD12		(12 << 24 | RSP_TYPE_R1B  |  1 << 4)
#define SDMMC_CMD13		(13 << 24 | RSP_TYPE_R1   |  1 << 4)
#define SDMMC_CMD15		(15 << 24 | RSP_TYPE_NONE |  1 << 4)
#define SDMMC_CMD16		(16 << 24 | RSP_TYPE_R1   |  1 << 4)
#define SDMMC_CMD17		(17 << 24 | RSP_TYPE_R1   |  1 << 21 | 1 << 4)
#define SDMMC_CMD24		(24 << 24 | RSP_TYPE_R1   |  1 << 21 | 0 << 4)
#define SDMMC_ACMD6		(6  << 24 | RSP_TYPE_R1   |  1 << 4)
#define SDMMC_ACMD41	(41 << 24 | RSP_TYPE_R3   |  1 << 4)
#define SDMMC_ACMD51	(51 << 24 | RSP_TYPE_R1   |  1 << 21 | 0 << 4)
#define SDMMC_CMD55		(55 << 24 | RSP_TYPE_R1   |  1 << 4)
#define SDMMC_CMD52	 	(52 << 24 | RSP_TYPE_R5 | 1 << 4 | 1 << 21) 

/* DM814X SDMMC Controller register defnitions */
typedef struct hsmmc {
	UINT8  res1[0x110];
	UINT32 sysconfig;
	UINT32 sysstatus;
	UINT8  res2[0x14];
	UINT32 con;
	UINT8  res3[0xD4];
	UINT32 blk;
	UINT32 arg;
	UINT32 cmd;
	UINT32 rsp10;
	UINT32 rsp32;
	UINT32 rsp54;
	UINT32 rsp76;
	UINT32 data;
	UINT32 pstate;
	UINT32 hctl;
	UINT32 sysctl;
	UINT32 stat;
	UINT32 ie;
	UINT8 res4[0x8];
	UINT32 capa;
}hsmmc_t;


/* HSMMC_STAT Defnitions */
#define STAT_CC			(1 << 0)
#define STAT_TC			(1 << 1)
#define STAT_BGE		(1 << 2)
#define STAT_BWR		(1 << 4)
#define STAT_BRR		(1 << 5)
#define STAT_CIRQ		(1 << 8)
#define STAT_OBI		(1 << 9)
#define STAT_ERRI		(1 << 15)
#define STAT_CTO		(1 << 16)
#define STAT_CCRC		(1 << 17)
#define STAT_CEB		(1 << 18)
#define STAT_CIE		(1 << 19)
#define STAT_DTO		(1 << 20)
#define STAT_DCRC		(1 << 21)
#define STAT_DEB		(1 << 22)
#define	STAT_ACE		(1 << 24)
#define STAT_CERR		(1 << 28)
#define	STAT_BADA		(1 << 29)

#define SDIO_CARD		(1)
#define SD_CARD			(2)
#define MMC_CARD		(3)
#define UNKNOWN_CARD	(-1)	


void mmcinit (hsmmc_t *mmc_base);
INT32 detect_card(hsmmc_t *mmc_base, INT32 *is_high_cap);
INT32 bread  (hsmmc_t *mmc_base, INT32 highcap, INT32 blkno, UINT32 nbytes, UINT8 *buf);
INT32 bwrite (hsmmc_t *mmc_base, INT32 highcap, INT32 blkno, UINT32 nbytes, UINT8 *buf);

#endif
